/****************************************************************************
** Записать информацию о приборах в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
  var listPKU = armSkif.getListPKU(); // Список пультов

  for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
  {
    var numPKU = listPKU[i]; // Номер пульта

    var listDevice = armSkif.getListDevices(numPKU); // Список приборов

    for (var j=0; j<listDevice.length; ++j) // Цикл для каждого прибора
    {    
      var device = listDevice[j]; // Номер прибора
      
      armSkif.writeLog("Device [" + device + // Записать в лог номер прибора,
	"], type:"   + armSkif.getDeviceType(numPKU, device) +	// тип прибора,
	": "	     + armSkif.getDeviceTypeStr(numPKU, device) + //тип прибора,
	", ver: "    + armSkif.getDeviceVersion(numPKU, device) + // версию прибора,
	", part: "   + armSkif.getDevicePart(numPKU, device) +	// раздел, в который входит прибор
	", tamper: " + armSkif.convertStateToDescript( armSkif.getDeviceTamperState(numPKU, device) )+	// состояние тампера,
	", power: "  + armSkif.convertStateToDescript( armSkif.getDevicePowerState (numPKU, device) ) ); // состояние электропитания
      
      armSkif.writeLog("	Sh: " + armSkif.getListSh    (numPKU, device)); // Количество шлейфов
      armSkif.writeLog("	Ex: " + armSkif.getListExit  (numPKU, device)); // Количество контролируемых выходов
      armSkif.writeLog("	Rl: " + armSkif.getListRelay (numPKU, device)); // Количество реле
      armSkif.writeLog("	Rd: " + armSkif.getListReader(numPKU, device)); // Количество считывателей  
    }
  }
}