/****************************************************************************
** Данный скрипд демонстрирует возможности системы по управлению разделами в 
** зависимости от интервала времени. В 20:00 происхоит постановка на охрану
** всех разделов, в 7:00 происходит снятие с охраны всех разделов.
****************************************************************************/

const hourArm     =  20; // Час постановки на охрану
const hourDisArm  =   7; // Час снятия с охраны

// Записать в лог строку о запуске скрипта.
armSkif.writeLog( "Start script: " + scriptFileName );

var time = new Date();
time.setHours(hourArm,0,0, 0); // Задать время постановки на охрану
armSkif.setSheduler(timerEventArm, time); // Вызвать функцию timerEventArm в заданное время

time.setHours(hourDisArm,0,0, 0); // Задать время снятия с охраны
armSkif.setSheduler(timerEventDisArm, time); // Вызвать функцию timerEventDisArm в заданное время

// После опроса доступных приборов, вызвать функцию pollFinished, которая в
// зависимости от интервала времени производит постановку или снятие с охраны
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function timerEventArm()
{
  //Взять на охрану все разделы, которые не на охране
  controlPart(true); // Данная функция определена ниже
  
  // Вызвать функцию timerEventArm в заданное время
  var time = new Date();
  time.setHours(hourArm,0,0, 0);    
  armSkif.setSheduler(timerEventArm, time);  
}
//---------------------------------------------------------------------------
function timerEventDisArm()
{
  //Снять с охраны все разделы, которые не сняты с охраны.
  controlPart(false); // Данная функция определена ниже
  
  // Вызвать функцию timerEventDisArm в заданное время
  var time = new Date();
  time.setHours(hourArm,0,0, 0);    
  armSkif.setSheduler(timerEventDisArm, time);  
}
//---------------------------------------------------------------------------
// Данная функция проверяет наступление определенных интервалов времени и
// выполняет постановку/снятие разделов.
//---------------------------------------------------------------------------
function pollFinished()
{
  var date  = new Date();       // Текущая дата и время
  var hours = date.getHours();  // Час  
  
  if ( (hours>=hourArm) || (hours< hourDisArm) ) 
    controlPart(true);
  else 
    controlPart(false);
}
//---------------------------------------------------------------------------
// Данная функция выполняет постановку (control==true), либо снятие
// (control==false) всех разделов всех пультов.
//---------------------------------------------------------------------------
function controlPart(control)
{  
  const stateArm    =  24; // Состояния "На охране"
  const stateDisArm = 109; // Состояния "Снят с охраны"

  var listPKU = armSkif.getListPKU();	 // Список пультов
  
  for (var i = 0; i<listPKU.length; ++i)	 // Цикл для каждого пульта
  {
    var numPKU = listPKU[i];			 // Номер пульта
    var listParts = armSkif.getListParts(numPKU);// Список разделов пульта

    for (var j = 0; j<listParts.length; ++j)	 // Цикл для каждого раздела
    {
      var part = listParts[j];			 // Номер раздела
      var partState = armSkif.getPartState(numPKU, part);// Состояние раздела
            
      if (control)
      {    
	if ( partState != stateArm ) armSkif.controlPart_Arm(numPKU, part);// Постановка
      }
      else
      {
	if ( partState != stateDisArm ) armSkif.controlPart_DisArm(numPKU, part);// Снятие
      }      
    }
  }
}