/****************************************************************************
** Демонстрация соединения скрипта с внешним ПО при помощи протокола MQTT
** (Message Queuing Telemetry Transport) - протокол обмена сообщениями,
** реализующий модель "публикация/подпись". Для обмена по этому протоколу
** требуется брокер (сервер) MQTT, например mosquitto. Скрипт соединяется с
** брокером, подписывается на сообщение, публикует сообщение, получает это же
** сообщение от брокера и записывает его в лог-файл.
** Сценарий для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var timerReconnect = 0; //Таймер попдключения в случае ошибки или разрыва соединения

// Инициализация глобального объекта "mqtt"
mqtt.init("localhost", 1883, "clientId", "user", "password");

// Соединение сигналов объекта mqtt с функциями скрипта. Функции описаны ниже.
// Основные сигналы:
mqtt.connacked.connect   ( connacked );
mqtt.received.connect    ( received );
mqtt.error.connect       ( error );
mqtt.disconnected.connect( disconnected );

// Вспомогательные сигналы. Могут понадобиться при отладке:
mqtt.connected.connect  ( connected );
mqtt.subacked.connect   ( subacked );
mqtt.unsubacked.connect ( unsubacked );

mqtt.connect(); // Подключиться к брокеру.

//---------------------------------------------------------------------------
// Функция вызывается при подтверждении установления соединения с брокером.
// Не путать с функцией connected (см. далее).
//---------------------------------------------------------------------------
function connacked()
{
    armSkif.writeLog( scriptFileName + " (connacked)");

    mqtt.subscribe("test/test/#"); // Подписаться на все сообщения топика "test/test/"
    //mqtt.unsubscribe("test/test/#"); // Отписаться от всех сообщений топика "test/test/"

    // Опубликовать сообщение в топике "test/test/1".
    // true - брокер будет хранить сообщение данного топика даже при перезагрузке.
    mqtt.publish("test/test/1", "test1 проверка1", true);
}
//---------------------------------------------------------------------------
//Функция вызывается при получении сообщении от брокера.
//---------------------------------------------------------------------------
function received(topic, payload)
{    armSkif.writeLog( scriptFileName + " (received): " + topic +": "+ payload);
}
//---------------------------------------------------------------------------
// Функция вызывается при возникновении ошибки в процессе соединения.
//---------------------------------------------------------------------------
function error(err)
{
    armSkif.writeLog( scriptFileName + " (error): " +err);

    mqtt.disconnect(); // Отключиться от брокера.
    timeReconnect();
}
//---------------------------------------------------------------------------
// Функция вызывается при отключении от брокера.
//---------------------------------------------------------------------------
function disconnected()
{
    armSkif.writeLog( scriptFileName + " (disconnected)");

    timeReconnect();
}
//---------------------------------------------------------------------------
// Переподключиться в случае отключения или ошибки
//---------------------------------------------------------------------------
function timeReconnect()
{
    // Через одну секунду вызвать функцию reconnect
    if (timerReconnect==0)
        timerReconnect = armSkif.setTimeout(reconnect, 1000);
}
//---------------------------------------------------------------------------
function reconnect()
{
    timerReconnect = 0;
    mqtt.connect();    // Подключиться к брокеру.
}



//===========================================================================
// Далее приведены вспомогательные функции.
// Эти функции не обязательно применять, они могут помочи при отладке скрипта.

//---------------------------------------------------------------------------
// Функция вызывается при установлении соединения с брокером.
// Подтверждение еще не получено, но TCP-соединение уже установлено.
//---------------------------------------------------------------------------
function connected()
{
    armSkif.writeLog( scriptFileName + " (connected)");
}
//---------------------------------------------------------------------------
// Функция вызывается при подтверждении подписки, mid - количество подписок.
//---------------------------------------------------------------------------
function subacked(mid)
{
    armSkif.writeLog( scriptFileName + " (subacked): " + mid );
}
//---------------------------------------------------------------------------
// Функция вызывается при подтверждении отписки, mid - количество подписок.
//---------------------------------------------------------------------------
function unsubacked(mid)
{
    armSkif.writeLog( scriptFileName + " (unsubacked): " + mid);
}

