/****************************************************************************
** Переключить раскладку окон монитора на сервере видеонаблюдения Трассир при 
** тревоге в разделе. Сценарий для сервера, поместить в каталог ScriptsServer
*****************************************************************************
** Сценарий отправляет на сервер Трассир строку по протоколу HTTPS (запрос GET), где:
** 127.0.0.1 – адрес компьютера, на котором установлен Трассир,
** operatorgui_FpbciTe0 – название рабочего места, можно посмотреть в настройках сервера Трассир -> “Веб-сервер” -> “Дерево объектов” -> “Показать”,
** 123 – пароль к SDK, задается в настройках сервера Трассир -> “Веб-сервер”,
** test1 – название раскладки мониторов,
** monitor_n=1 – номер монитора.
****************************************************************************/

const numPKU  = 1; // Номер пульта
const numPart = 1; // Номер раздела
  
// Если состояние какого-нибудь раздела изменится, то вызвать функцию.
armSkif.signalUpdatePart.connect( updatePart );

//---------------------------------------------------------------------------
function updatePart(nPKU, nPart)
{
  if ( (nPKU == numPKU) && (nPart == numPart) ) // Если нужный раздел, то:
  {
    var partState = armSkif.getPartState(nPKU, nPart);// Состояние раздела
    
    if ( armSkif.isAlarmState(partState) ) // Если тревога, то отправить на сервер Трассир строку:
      armSkif.networkRequestGET("https://127.0.0.1:8080/objects/operatorgui_FpbciTe0/show_template?password=123&template_name=test1&monitor_n=1");    
  }
}









