﻿/****************************************************************************
** При тревоге проникновения, включить реле с задержкой 10 минут. В случае если
** раздел перейдет из тревоги в другое состояние, то отменить включение реле.
** Сценарий для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var numPKU  = 1; // Номер пульта
var numPart = 1; // Номер раздела
var numDev  = 1; // Номер прибора
var numRelay= 1; // Номер реле

var stateAlarm =  3;  // Состояние "Тревога проникновения"

var timerID= -1;

// Если состояние какого-нибудь раздела изменится, то вызвать функцию.
armSkif.signalUpdatePart.connect( updatePart );

//---------------------------------------------------------------------------
function updatePart(nPKU, nPart)
{
    if ( (nPKU == numPKU) && (nPart == numPart) ) // Если нужный раздел, то:
    {
        var partState = armSkif.getPartState(nPKU, nPart);// Состояние раздела

        if (partState == stateAlarm) // Если "Тревога проникновения", то:
        { // Запланировать вызов функции "controlRelay" через 10 минут
            if (timerID == -1)
                timerID = armSkif.setTimeout(controlRelay, 600000);
        }
        else
        {
            //Выключить реле
            armSkif.controlRelay(numPKU, numDev, numRelay, armSkif.RL_OFF); // Выключить реле

            if (timerID != -1)
            { // Отменить отложенный вызов функции
                armSkif.clearTimeout(timerID);
                timerID = -1;
            }
        }
    }
}
//---------------------------------------------------------------------------
function controlRelay()
{
    armSkif.controlRelay(numPKU, numDev, numRelay, armSkif.RL_ON ); // Включить реле
}
