﻿/****************************************************************************
** Отправка тревог в SMS сообщении при помощи GSM модема.
** Протестированы модемы: Huawei E150, E171, E3272, E3372
**
** Для работы GSM-модемов в windows необходимо установить универсальный драйвер:
** https://huawei-drivers.ru/huawei-e3272-driver-windows-download.html
** После установки драйвера появятся несколько COM-портов (2...3).
** Бывает, что модем в программе работает с любым портом, но с каким-то более
** стабильно, проверяйте. Некоторые модемы меняют номер стабильного порта при
** переподключении, но SMS всеравно отправляются, просто программа автоматически
** закрывает и заново открывает последовательный порт при ошибках.
**
** Перед работой с модемом в сценариях рекомендуется поработать с модемом в
** графическом интерфейсе программы PEventReader:
** http://forum-bolid.ru/viewtopic.php?f=219&t=3949
**
** Сценарий только для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var tel = "79180000000"; // Номер телефона.

//------------------------------------------------------------------------------
// Начало работы с GSM модемом.
//------------------------------------------------------------------------------
sms.changePort("COM1");   // Выбор последовательного порта модема для windows
//sms.changePort("ttyUSB0");  // Выбор последовательного порта модема для Linux
sms.start(); // Открыть порт и начать обмен.

//------------------------------------------------------------------------------
armSkif.signalNewEvent.connect( newEvent );// Вызвать функцию newEvent при поступлении нового события
function newEvent(nPKU, count)
{
    if (count>0)
    {
        var n = count - 1; // Порядковый номер события в базе данных
        var event = armSkif.getEvent(nPKU, n); // Код события

        if ( armSkif.isAlarmState(event) ) // Если событие тревожное, то:
        {
            var date = armSkif.getEventDate(nPKU, n); // Дата и время события

            var str = "[" + (''+date.getDate()).padStart(2,'0')  + "." + (''+date.getMonth()).padStart(2,'0')   + "." + date.getFullYear() +                      // Дата
                    "]["+ (''+date.getHours()).padStart(2,'0') + ":" + (''+date.getMinutes()).padStart(2,'0') + ":" + (''+date.getSeconds()).padStart(2,'0')  + // Время
                    "] " + armSkif.convertStateToDescript(event) +// Событие в текстовом виде
                    "; Раздел " + armSkif.getEventPart(nPKU, n) + // Номер раздела
                    "; " + armSkif.getEventDescr(nPKU, n) +       // Описание события
                    "; " + armSkif.getEventAddr (nPKU, n) + ".";  // Адрес агрегата в текстовом виде

            sms.sendMsg(tel, str);
        }
    }
}
//------------------------------------------------------------------------------
// Все что ниже - нужно только для отладки, в обычном скрипте
// можно не использовать. Закомментировано.
//------------------------------------------------------------------------------
/*
// Подключение отладочных сигналов к функциям.
sms.signalError.connect   ( gsmErr );
sms.signalLevel.connect   ( gsmLevel );
sms.signalOperator.connect( gsmOperator );
sms.signalModel.connect   ( gsmModel );
//------------------------------------------------------------------------------
function gsmErr(err)
{
    armSkif.writeLog("GSM: " + err);
}
//------------------------------------------------------------
function gsmLevel(level)
{
    armSkif.writeLog("GSM signal: " + level);
}
//------------------------------------------------------------
function gsmOperator(state, name)
{
    armSkif.writeLog("GSM state: " + state + ", operator: " + name);
}
//------------------------------------------------------------
function gsmModel(manufacturer, model, imei)
{
    armSkif.writeLog("GSM model: " + manufacturer + ", " + model + ", " + imei);
}

//------------------------------------------------------------------------------
// Запись в лог в самом конце сценария, чтобы было видно, что выполнение
// сценария дошло до указанного места без ошибок.
// Логи смотрите в файле Log/Программа/script.log
armSkif.writeLog("Test SMS");
*/
