﻿/****************************************************************************
** Пример постановки на охрану указанных разделов.
****************************************************************************/

var numPKU = 1;         // Номер пульта
var parts  = [2, 3, 4]; // Номера разделов

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
    var stateArm    =  24; // Состояния "На охране"
    var stateDisArm = 109; // Состояния "Снят с охраны"

    for (var i = 0; i<parts.length; ++i)	 // Цикл для каждого раздела
    {
        var part = parts[i]; // Номер раздела
        var partState = armSkif.getPartState(numPKU, part);// Состояние раздела

        if ( partState != stateArm )
            armSkif.controlPart_Arm(numPKU, part);// Постановка

        //if ( partState != stateDisArm )
        //armSkif.controlPart_DisArm(numPKU, part);// Снятие
    }
}
