﻿/****************************************************************************
** Отправка почты по протоколу SMTP.
** Чтобы не показывать пароль от своего почтового ящика посторонним лицам,
** которые могут посмотреть текст данного сценария, рекомендуется создать
** отдельный почтовый ящик и отправлять с него письма на свой почтовый ящик.
** Почту можно отправлять несколькими способами, ниже описаны варианты.
****************************************************************************/

var sendTo   = "to@mail.ru";    // Почтовый адрес "Кому"
var sendFrom = "from@mail.ru";  // Почтовый адрес "От кого"
var password = "password";      // Пароль почтового ящика "От кого"
var subject  = "Тема письма";
var smtpHost = "smtp.mail.ru";
var smtpPort = 465;

//------------------------------------------------------------------------------
// Вывод статуса отправки почты в файл лога.
// Нужно только для отладки, в дальнейшем можно не использовать.
//------------------------------------------------------------------------------
smtp.status.connect( logSMTP ); // Подключаем сигнал status к функции logSMTP
function logSMTP(msg)
{
    armSkif.writeLog("SMTP: " + msg); // Запись в файл лога
    // Логи смотрите в файле Log/Программа/script.log
}

//------------------------------------------------------------------------------
// Вариант №1
// Отправка почты одной командой. Не самый удобный вариант.
//------------------------------------------------------------------------------
smtp.send(sendTo, sendFrom, password, subject, "Проверка почты, вариант 1.", smtpHost, smtpPort);

//------------------------------------------------------------------------------
// Вариант №2
// Можно заранее задать параметры отправки, а потом вызывать функцию send
// сколько угодно раз.
//------------------------------------------------------------------------------
smtp.setAddress(sendTo, sendFrom, password, subject, smtpHost, smtpPort);
smtp.send("Проверка почты, вариант 2.");

//------------------------------------------------------------------------------
// Вариант №3
// Отправка почты с задержкой.
// Несколько сообщений попадут в одно письмо в пределах задержки.
// Время задержки отсчитывается с первого не отправленного сообщения.
//------------------------------------------------------------------------------
smtp.setAddress(sendTo, sendFrom, password, subject, smtpHost, smtpPort);
smtp.setDelay(10); // Задержка 10 секунд.
smtp.sendDelay("Проверка почты, вариант 3, первое сообщение.");
smtp.sendDelay("Проверка почты, вариант 3, второе сообщение.");
smtp.sendDelay("Проверка почты, вариант 3, третее сообщение.");

//------------------------------------------------------------------------------
// Запись в лог в самом конце сценария, чтобы было видно, что выполнение
// сценария дошло до указанного места без ошибок.
// Логи смотрите в файле Log/Программа/script.log
armSkif.writeLog("Test SMTP");
