﻿/****************************************************************************
** Записать информацию о группах разделов в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
    var listPKU = armSkif.getListPKU(); // Список пультов

    for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
    {
        var numPKU = listPKU[i]; // Номер пульта

        var listGParts = armSkif.getListGParts(numPKU); // Список групп разделов

        for (var j=0; j<listGParts.length; ++j) // Цикл для каждой группы разделов
        {
            var gpart = listGParts[j]; // Номер группы разделов
            armSkif.writeLog("GPart " + gpart + // Записать в лог номер группы разделов,
                             ", " 	    + armSkif.getPartDescription(numPKU, gpart) + // описание группы разделов,
                             ", " 	    + armSkif.convertStateToDescript( armSkif.getPartState(numPKU, gpart) ) + //состояние группы разделов,
                             ", Parts: " + armSkif.getListGPartParts(numPKU, gpart) ); // список разделов в группе разделов.
        }
    }
}
