﻿/****************************************************************************
** Демонстрация запроса одного из трёх значений:
** 1. Запылённость (для ДИП-34А);
** 2. Счётчик (С2000-АСР2/8);
** 3. Интервал недостоверности (С2000-АСР2/8).
** Сценарий для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var numPKU   = 1; // Номер пульта
var numDev   = 1; // Номер прибора
var numSh    = 1; // Номер шлейфа
var fileName = "test/adc2.txt"; // Файл для записи значений (путь относительно каталога Log\Название_программы)

//---------------------------------------------------------------------------
var numFsh = armSkif.convert2ByteToWord(numDev, numSh); // Полный номер шлейфа (прибор, шлейф)

// Вызвать функцию updateADC2 если получено АЦП шлейфа.
armSkif.signalUpdateDust.connect( updateADC2 );
//armSkif.signalUpdateCount.connect( updateADC2 );
//armSkif.signalUpdateInterval.connect( updateADC2 );

// Запланировать вызов функции "requestADC2" с интервалом 5 секунд
armSkif.setInterval(requestADC2, 5000);

//---------------------------------------------------------------------------
function requestADC2()
{
    armSkif.requestDust(numPKU, numFsh);     // Запрос запылённости.
    //armSkif.requestCount(numPKU, numFsh);    // Запрос показаний счётчика (С2000-АСР2/8).
    //armSkif.requestInterval(numPKU, numFsh); // Запрос интервала недостоверности (С2000-АСР2/8).
}

//---------------------------------------------------------------------------
function updateADC2(nPKU, fsh, val)
{
    if ( (numPKU==nPKU) && (numFsh==fsh) ){ // Если нужный номер шлейфа
        var date = new Date(); // Текущая дата

        var str = date.getDate()   + "." +
                date.getMonth()    + "." +
                date.getFullYear() + "; "+

                date.getHours()    + ":" +
                date.getMinutes()  + ":" +
                date.getSeconds()  + "; " +

                "Запыленность: "
                //"Счетчик: "
                //"Интервал: "
                + val + "\n";

        armSkif.writeFile(fileName, str); // Записать в файл
    }
}
