﻿/****************************************************************************
** Отправить тревоги на почту.
** Сценарий только для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var sendTo   = "to@mail.ru";    // Почтовый адрес "Кому"
var sendFrom = "from@mail.ru";  // Почтовый адрес "От кого"
var password = "password";      // Пароль почтового ящика "От кого"
var subject  = "Охранная сигнализация, тревога!";
var smtpHost = "smtp.mail.ru";
var smtpPort = 465;

//------------------------------------------------------------------------------
smtp.setAddress(sendTo, sendFrom, password, subject, smtpHost, smtpPort); // Задать параметры почты
smtp.setDelay(10); // Задержка 10 секунд для отправки почты командой smtp.sendDelay.

//------------------------------------------------------------------------------
armSkif.signalNewEvent.connect( newEvent );// Вызвать функцию newEvent при поступлении нового события
function newEvent(nPKU, count)
{
    if (count>0)
    {
        var n = count - 1; // Порядковый номер события в базе данных
        var event = armSkif.getEvent(nPKU, n); // Код события
                
        if ( armSkif.isAlarmState(event) ) // Если событие тревожное, то:
        {
            var date = armSkif.getEventDate(nPKU, n); // Дата и время события

            var str = "[" + (''+date.getDate()).padStart(2,'0')  + "." + (''+date.getMonth()).padStart(2,'0')   + "." + date.getFullYear() +                      // Дата
                      "]["+ (''+date.getHours()).padStart(2,'0') + ":" + (''+date.getMinutes()).padStart(2,'0') + ":" + (''+date.getSeconds()).padStart(2,'0')  + // Время
                      "] " + armSkif.convertStateToDescript(event) +// Событие в текстовом виде
                      "; Раздел " + armSkif.getEventPart(nPKU, n) + // Номер раздела
                      "; " + armSkif.getEventDescr(nPKU, n) +       // Описание события
                      "; " + armSkif.getEventAddr (nPKU, n) + ".";  // Адрес агрегата в текстовом виде

            smtp.send(str); // Отправить тревогу на почту

            // Если требуется объединить несколько тревог в одном письме в пределах задержки см. smtp.setDelay(10)
            // Это может сократить количество писем, например если при входе в здание нарушается сразу несколько шлейфов.
            //smtp.sendDelay(str);
        }
    }
}
//------------------------------------------------------------------------------
// Вывод статуса отправки почты в файл лога.
// Нужно только для отладки, в дальнейшем можно не использовать.
//------------------------------------------------------------------------------
/*
smtp.status.connect( logSMTP ); // Подключаем сигнал status к функции logSMTP
function logSMTP(msg)
{
    armSkif.writeLog("SMTP: " + msg); // Запись в файл лога
    // Логи смотрите в файле Log/Программа/script.log
}
*/
