/****************************************************************************
** Записать информацию о разделах в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
  var listPKU = armSkif.getListPKU(); // Список пультов

  for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
  {
    var numPKU = listPKU[i]; // Номер пульта
    
    var listParts = armSkif.getListParts(numPKU); // Список разделов

    for (var j=0; j<listParts.length; ++j) // Цикл для каждого раздела  
    {
      var part = listParts[j]; // Номер раздела
      armSkif.writeLog("Part " + part + // Записать в лог номер раздела,
	", "       + armSkif.getPartDescription(numPKU, part) + // описание раздела,
	", "       + armSkif.convertStateToDescript( armSkif.getPartState(numPKU, part) ) + // состояние раздела,
	", Sh: "   + armSkif.getListPartSh  (numPKU, part) +  // список шлейфов раздела,
	", Eixt: " + armSkif.getListPartExit(numPKU, part) +  // список контролируемых выходов раздела
	", Dev: "  + armSkif.getListPartDev (numPKU, part) ); // список приборов раздела      
    }
  }
}