/****************************************************************************
** Записать информацию о контролируемых выходах в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
  var listPKU = armSkif.getListPKU(); // Список пультов

  for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
  {
    var numPKU = listPKU[i]; // Номер пульта

    var listDevice = armSkif.getListDevices(numPKU); // Список приборов

    for (var j=0; j<listDevice.length; ++j) // Цикл для каждого прибора
    {
      var device = listDevice[j]; // Номер прибора
      
      var listEixt = armSkif.getListExit(numPKU, device); // Список контролируемых выходов
      
      for (var k=0; k<listEixt.length; ++k) // Цикл для каждого контролируемого выхоа
      {
	var ex = listEixt[k]; // Номер контролируемого выхода
	
	armSkif.writeLog("Ex [" + device + "/" + ex +                 // Записать в лог номер выхода,
	"], descript: " + armSkif.getRelayDescription(numPKU, device, ex) + // описание,
	", part: "      + armSkif.getExitPart(numPKU, device, ex) +        // раздел, в который входит выход
	", state: "     + armSkif.convertStateToDescript( armSkif.getExitState(numPKU, device, ex) ) ); // состояние
      }
    }
  }
}