/****************************************************************************
** Записать информацию о реле в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
  var listPKU = armSkif.getListPKU(); // Список пультов

  for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
  {
    var numPKU = listPKU[i]; // Номер пульта

    var listDevice = armSkif.getListDevices(numPKU); // Список приборов

    for (var j=0; j<listDevice.length; ++j) // Цикл для каждого прибора
    {
      var device = listDevice[j]; // Номер прибора
      
      var listRl = armSkif.getListRelay(numPKU, device); // Список реле
      
      for (var k=0; k<listRl.length; ++k) // Цикл для каждого реле
      {
	var rl = listRl[k]; // Номер реле
	
	armSkif.writeLog("Rl [" + device + "/" + rl +                 // Записать в лог номер реле,
	"], descript: " + armSkif.getRelayDescription(numPKU, device, rl) + // описание,
	", state: "     + armSkif.getRelayState(numPKU, device, rl) ); // состояние
      }
    }
  }
}