/****************************************************************************
** Дописывать в конец файла все вновь поступившие события для экспорта их в
** стороннюю систему учета рабочео времени (напимер на базе 1С).
** Имя файла: год_месяц_день.txt
** Структура файла: номер прибора; номер зоны доступа; событие; час; минут; секунда; код пропуска
** Номера событий можно посмотреть в файле Doc\Scripts.pdf (таблица A.7)
** Сценарий только для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var numPKU = 1; // Номер пульта
var pathName = "test/"; // Каталог для записи файлов (относительно каталого log)

armSkif.signalNewEvent.connect( newEvent );// Вызвать функцию newEvent при поступлении нового события

//---------------------------------------------------------------------------
function newEvent(nPKU, count){
    if ( (numPKU==nPKU) && (count>0)){ // Если событие для нужного пульта
        var n = count - 1; // Порядковы номер события в базе данных

        var date = armSkif.getEventDate(numPKU, n); // Дата/время события
	var zone = armSkif.getEventZone(numPKU, n); // Зона доступа (для СКУД)

        var str=armSkif.getEventDev(numPKU, n) + ";" +
	        ((zone=-1) ? "": zone) + ";" +	    // Зона доступа (для СКУД)
                armSkif.getEvent(numPKU, n)  + ";" +
                date.getHours() + ";" +
                date.getMinutes() + ";" +
                date.getSeconds() + ";" +
                armSkif.getEventKey(numPKU, n) + "\n";

        var datef= new Date(); // Текущая дата (для имени файла)
        var fileName = pathName + // Имя файла: год_месяц_день.txt
                datef.getFullYear() + "_" +
                datef.getMonth() + "_" +
                datef.getDate() + ".txt";

        armSkif.writeFile(fileName, str); // Записать в файл
    }
}
