﻿/****************************************************************************
** Показать сообщение при изменении состояния раздела
****************************************************************************/

var numServer = 1; // Номер сервера
var numPKU    = 1; // Номер пульта
var numPart   = 1; // Номер раздела

var serverNumPKU = armSkif.convert2ByteToWord(numServer, numPKU);

// Если состояние какого-нибудь раздела изменится, то вызвать функцию.
armSkif.signalUpdatePart.connect( updatePart );

//---------------------------------------------------------------------------
function updatePart(nPKU, nPart)
{
    if ( (nPKU == serverNumPKU) && (nPart == numPart) ) // Если нужный раздел, то показать сообщение:
        armSkif.messageInformation("Информация", "Изменилось состояние раздела (" + numPart + ")\n" +
                                   armSkif.getPartDescription(nPKU, nPart) + "\n" +
                                   armSkif.convertStateToDescript( armSkif.getPartState(nPKU, nPart) ) );
}
