/****************************************************************************
** Запросить АЦП группы шлейфов и записать полученное значение в файл.
** Сценарий для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/
var fileName = "test/adc.txt"; // Файл для записи АЦП (путь относительно каталого log)

var numPKU   = 1; // Номер пульта
var numDev   = 10; // Номер прибора
var numFSh   = [51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71]; // Номера шлейфов

var int8 = new Int8Array(numFSh.length); // В этом массиве будет результат запроса АЦП

//---------------------------------------------------------------------------
for (var i = 0; i<numFSh.length; ++i) // Цикл для каждого шлейфа
{
    // Полный номер шлейфа (прибор, шлейф)
    numFSh[i] = armSkif.convert2ByteToWord(numDev, numFSh[i]);
}
//---------------------------------------------------------------------------
// Вызвать функцию updateADC если получено АЦП шлейфа.
armSkif.signalUpdateADC.connect( updateADC );

requestADC(); // Вызвать функцию запроса АЦП
armSkif.setInterval(requestADC, 5000); // Запланировать вызов функции "requestADC" с интервалом 5 екунд

//---------------------------------------------------------------------------
function requestADC()
{
    armSkif.setTimeout(printADC, 4000); // Вызвать функцию printADC через 4 секунды

    for (var i = 0; i<numFSh.length; ++i)
    {
        int8[i] = 0; // Обнулим элемент
        armSkif.requestShADC(numPKU, numFSh[i]); // Запросить АЦП шлейфа. Ответ будет в updateADC.
    }
}
//---------------------------------------------------------------------------
function updateADC(nPKU, fsh, adc, value) // Получено значение АЦП
{
    if (nPKU===numPKU) // Если нужный пульт
    {
        var index = numFSh.indexOf(fsh);
        if (index>=0){ // Если нужный шлейф
            int8[index] = adc;
        }
    }
}
//---------------------------------------------------------------------------
function printADC()
{
    var date = new Date(); // Текущая дата

    var str=("0" + date.getDate()).slice(-2) + "." +
            ("0" + date.getMonth()).slice(-2) + "." +
            date.getFullYear() + ";" +
            ("0" + date.getHours()).slice(-2) + ":" +
            ("0" + date.getMinutes()).slice(-2) + ":" +
            ("0" + date.getSeconds()).slice(-2);

    for (var i = 0; i<numFSh.length; ++i)
    {
        str += ";" + (numFSh[i] & 0xff) + ";" + int8[i];
    }

    armSkif.writeFile(fileName, str + "\n"); // Записать в файл
}
