﻿/****************************************************************************
** Записать информацию о считывателях в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
    var listPKU = armSkif.getListPKU(); // Список пультов

    for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
    {
        var numPKU = listPKU[i]; // Номер пульта

        var listDevice = armSkif.getListDevices(numPKU); // Список приборов

        for (var j=0; j<listDevice.length; ++j) // Цикл для каждого прибора
        {
            var device = listDevice[j]; // Номер прибора

            var listReader = armSkif.getListReader(numPKU, device); // Список считывателей

            for (var k=0; k<listReader.length; ++k) // Цикл для каждого считывателя
            {
                var rd = listReader[k]; // Номер контролируемого выхода

                armSkif.writeLog("Rd [" + device + "/" + rd +                                         // Записать в лог номер считывателя,
                                 "], descript: " + armSkif.getReaderDescription(numPKU, device, rd) + // описание,
                                 ", state: "     + convertRdStateToDescript( armSkif.getReaderState(numPKU, device, rd) ) ); // состояние
            }
        }
    }
}
//---------------------------------------------------------------------------
function convertRdStateToDescript(stae)
{
    var ret;
    if (stae && 1) ret += "[запрет выхода (по кнопке)] ";
    if (stae && 2) ret += "[запрет выхода] ";
    if (stae && 4) ret += "[свободный проход]";

    return ret;
}
