﻿/****************************************************************************
** Запросить АЦП шлейфа и записать полученное значение в файл.
** Сценарий для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var numPKU   = 1; // Номер пульта
var numDev   = 1; // Номер прибора
var numSh    = 1; // Номер шлейфа
var fileName = "test/adc.txt"; // Файл для записи АЦП (путь относительно каталого log)

//---------------------------------------------------------------------------
var numFsh = armSkif.convert2ByteToWord(numDev, numSh); // Полный номер шлейфа (прибор, шлейф)

// Вызвать функцию updateADC если получено АЦП шлейфа.
armSkif.signalUpdateADC.connect( updateADC );

// Запланировать вызов функции "requestADC" с интервалом 1 екунду
armSkif.setInterval(requestADC, 1000);

//---------------------------------------------------------------------------
function requestADC()
{
    // Запросить АЦП шлейфа. Ответ будет в signalUpdateADC.
    armSkif.requestShADC(numPKU, numFsh);
}

//---------------------------------------------------------------------------
function updateADC(nPKU, fsh, adc, value){
    //armSkif.writeFile(fileName, nPKU +";"+ fsh +";"+ adc +";"+ value +"\n"); // Записать в файл

    if ( (numPKU==nPKU) && (numFsh==fsh) ){ // Если нужный номер шлейфа
        var date = new Date(); // Текущая дата

        var str = date.getDate()     + "." +
                date.getMonth()    + "." +
                date.getFullYear() + "; "+

                date.getHours()    + ":" +
                date.getMinutes()  + ":" +
                date.getSeconds()  + "; " +

                "АЦП: " + adc +
                "; Значение АЦП: " + value +
                "\n";

        armSkif.writeFile(fileName, str); // Записать в файл
    }
}
