﻿/****************************************************************************
** Записать информацию о шлейфах в лог.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
    var listPKU = armSkif.getListPKU(); // Список пультов

    for (var i=0; i<listPKU.length; ++i) // Цикл для каждого пульта
    {
        var numPKU = listPKU[i]; // Номер пульта

        var listDevice = armSkif.getListDevices(numPKU); // Список приборов

        for (var j=0; j<listDevice.length; ++j) // Цикл для каждого прибора
        {
            var device = listDevice[j]; // Номер прибора

            var listSh = armSkif.getListSh(numPKU, device); // Список шлейфов

            for (var k=0; k<listSh.length; ++k) // Цикл для каждого шлейфа
            {
                var sh = listSh[k]; // Номер шлейфа

                armSkif.writeLog("Sh [" + device + "/" + sh +                                     // Записать в лог номер шлейфа,
                                 "], descript: " + armSkif.getShDescription(numPKU, device, sh) + // описание,
                                 ", part: "      + armSkif.getShPart(numPKU, device, sh) +        // раздел, в который входит шлейф
                                 ", state: "     + armSkif.convertStateToDescript( armSkif.getShState(numPKU, device, sh) ) ); // состояние
            }
        }
    }
}
