﻿/****************************************************************************
** Пример постановки на охрану всех разделов.
****************************************************************************/

// Вызвать функцию pollFinished после опроса доступных приборов
armSkif.signalPollFinished.connect( pollFinished );

//---------------------------------------------------------------------------
function pollFinished()
{
    var stateArm    =  24; // Состояния "На охране"
    var stateDisArm = 109; // Состояния "Снят с охраны"

    var listPKU = armSkif.getListPKU(); // Список пультов

    for (var i = 0; i<listPKU.length; ++i) // Цикл для каждого пульта
    {
        var numPKU = listPKU[i]; // Номер пульта
        var listParts = armSkif.getListParts(numPKU);// Список разделов пульта

        for (var j = 0; j<listParts.length; ++j) // Цикл для каждого раздела
        {
            var part = listParts[j]; // Номер раздела
            var partState = armSkif.getPartState(numPKU, part);// Состояние раздела

            if ( partState != stateArm )
                armSkif.controlPart_Arm(numPKU, part);// Постановка

            //if ( partState != stateDisArm )
            //armSkif.controlPart_DisArm(numPKU, part);// Снятие
        }
    }
}
