﻿/****************************************************************************
** Включить реле при любой тревоге в разделе.
****************************************************************************/

var numPKU  = 1; // Номер пульта
var numPart = 1; // Номер раздела
var numDev  = 1; // Номер прибора
var numRelay= 1; // Номер реле

// Если состояние какого-нибудь раздела изменится, то вызвать функцию.
armSkif.signalUpdatePart.connect( updatePart );

//---------------------------------------------------------------------------
function updatePart(nPKU, nPart)
{
    if ( (nPKU == numPKU) && (nPart == numPart) ) // Если нужный раздел, то:
    {
        var partState = armSkif.getPartState(nPKU, nPart);// Состояние раздела

        if ( armSkif.isAlarmState(partState) ) // Если тревога, то:
            armSkif.controlRelay(numPKU, numDev, numRelay, armSkif.RL_ON ); // Включить реле
        else
            armSkif.controlRelay(numPKU, numDev, numRelay, armSkif.RL_OFF); // Выключить реле
    }
}
