﻿/****************************************************************************
** Получение сигналов от клавиатуры на вкладках "Тревоги" и "Дежурство" в
** клиентском ПО
****************************************************************************/

var keyNoModifier       = 0x02000000;
var keyShiftModifier    = 0x02000000;
var keyControlModifier  = 0x04000000;
var keyAltModifier      = 0x08000000;
var keyMetaModifier     = 0x10000000;
var keyKeypadModifier   = 0x20000000;
//---------------------------------------------------------------------------

//Вызвать функцию keyPress при нажатии клавиши на клавиатуре
armSkif.signalKeyPress.connect( keyPress );

//Вызвать функцию keyRelease при отжатии клавиши на клавиатуре
armSkif.signalKeyRelease.connect( keyRelease );

//---------------------------------------------------------------------------
function keyPress(key, modifiers)
{
    armSkif.writeLog("==============================");
    armSkif.writeLog("Нажата клавиша " + key + ", модификатор: " + modifiers);
    
    if (modifiers & keyShiftModifier  ) armSkif.writeLog("Модификатор Shift");
    if (modifiers & keyControlModifier) armSkif.writeLog("Модификатор Control");
    if (modifiers & keyAltModifier    ) armSkif.writeLog("Модификатор Alt");
    if (modifiers & keyMetaModifier   ) armSkif.writeLog("Модификатор Meta");
    if (modifiers & keyKeypadModifier ) armSkif.writeLog("Модификатор Keypad");
    
    
    // Если нужно отследить конкретные сочетания клавиш
    var keyS = 31;
    //if (  key == keyS ) armSkif.writeLog("Нажата кнопка s");
    //if ( (key == keyS) && (modifiers & keyNoModifier     ) ) armSkif.writeLog("Нажата кнопка s без модификатора");
    if ( (key == keyS) && (modifiers & keyControlModifier) ) armSkif.writeLog("Нажата кнопка Ctrl+s");
}

//---------------------------------------------------------------------------
function keyRelease(key, modifiers)
{
    armSkif.writeLog("----------------------");
    armSkif.writeLog("Отжата клавиша " + key + ", модификатор: " + modifiers);    
}
