﻿/****************************************************************************
** Отправка SMS сообщения при помощи GSM модема.
** Протестированы модемы: Huawei E150, E171, E3272, E3372
**
** Для работы GSM-модемов в windows необходимо установить универсальный драйвер:
** https://huawei-drivers.ru/huawei-e3272-driver-windows-download.html
** После установки драйвера появятся несколько COM-портов (2...3).
** Бывает, что модем в программе работает с любым портом, но с каким-то более
** стабильно, проверяйте. Некоторые модемы меняют номер стабильного порта при
** переподключении, но SMS всеравно отправляются, просто программа автоматически
** закрывает и заново открывает последовательный порт при ошибках.
**
** Перед работой с модемом в сценариях рекомендуется поработать с модемом в
** графическом интерфейсе программы PEventReader:
** http://forum-bolid.ru/viewtopic.php?f=219&t=3949
****************************************************************************/

var tel = "79180000000"; // Номер телефона.

//------------------------------------------------------------------------------
// Подключение отладочных сигналов к функциям. Нужно только для отладки, в
// дальнейшем можно не использовать. Просто закомментируйте эти строки.
//------------------------------------------------------------------------------
sms.signalError.connect   ( gsmErr );
sms.signalLevel.connect   ( gsmLevel );
sms.signalOperator.connect( gsmOperator );
sms.signalModel.connect   ( gsmModel );

//------------------------------------------------------------------------------
// Начало работы с GSM модемом.
//------------------------------------------------------------------------------
//sms.changePort("COM1");   // Выбор последовательного порта модема для windows
sms.changePort("ttyUSB0");  // Выбор последовательного порта модема для Linux
sms.start(); // Открыть порт и начать обмен.
//sms.stop(); // Закончить обмен и закрыть порт. Приведено для примера.

//------------------------------------------------------------------------------
// Отправка SMS сообщения.
//------------------------------------------------------------------------------
sms.sendMsg(tel, "Сообщение");

//------------------------------------------------------------
// Все что ниже - нужно только для отладки, в обычном скрипте
// можно не использовать.
//------------------------------------------------------------
function gsmErr(err)
{
    armSkif.writeLog("GSM: " + err);
}
//------------------------------------------------------------
function gsmLevel(level)
{
    armSkif.writeLog("GSM signal: " + level);
}
//------------------------------------------------------------
function gsmOperator(state, name)
{
    armSkif.writeLog("GSM state: " + state + ", operator: " + name);
}
//------------------------------------------------------------
function gsmModel(manufacturer, model, imei)
{
    armSkif.writeLog("GSM model: " + manufacturer + ", " + model + ", " + imei);
}

//------------------------------------------------------------------------------
// Запись в лог в самом конце сценария, чтобы было видно, что выполнение
// сценария дошло до указанного места без ошибок.
// Логи смотрите в файле Log/Программа/script.log
armSkif.writeLog("Test SMS");
