﻿/****************************************************************************
** При запуске сервера сохранить все события в файл (если файл не существует).
** Дописывать в конец файла все вновь поступившие события.
** Сценарий только для сервера (поместить в каталог Scripts\ScriptsServer).
****************************************************************************/

var numPKU = 1; // Номер пульта
var fileName = "test/allEvents.txt"; // Файл для записи событий (относительно каталого log)

//---------------------------------------------------------------------------
if (!armSkif.fileExists(fileName)){ // Если файл не суествует, то:
    var count = armSkif.getEventCount(numPKU); // Количество событий в БД

    for (var i=0; i<count;){
        var str="";

        for (var j=0; (j<1000) && (i<count); j++)
            str += strEvent(i++); // Функция описана ниже

        armSkif.writeFile(fileName, str); // Записать в файл
    }
}

armSkif.signalNewEvent.connect( newEvent );// Вызвать функцию newEvent при поступлении нового события

//---------------------------------------------------------------------------
function newEvent(nPKU, numEvent){
    if (numPKU==nPKU){ // Если событие для нужного пульта
        var str = strEvent(numEvent-1); // Функция описана ниже
        armSkif.writeFile(fileName, str); // Записать в файл
    }
}
//---------------------------------------------------------------------------
function strEvent(n){ // Функция возвращает информацию о событии с номером (n)
    var date = armSkif.getEventDate(numPKU, i); // Дата/время события
    var zone = armSkif.getEventZone(numPKU, i); // Зона доступа (для СКУД)

    var str =  n + ";" + // Порядковый номер события
            date.toLocaleDateString() + ";" + // Дата
            date.toLocaleTimeString() + ";" + // Время
            armSkif.convertStateToDescript( armSkif.getEvent(numPKU, n) )+ ";" + // Описание события
            armSkif.getEventPart(numPKU, n) + ";" + // Разде
            ((zone=-1) ? "": zone) + ";" +	    // Зона доступа (для СКУД)
            armSkif.getEventDescr(numPKU, n)+ ";" + // Описание события
            armSkif.getEventAddr(numPKU, n) + ";" + // Адрес (прибор/шлейф/реле/считыватель)
            armSkif.getEventUser(numPKU, n) + "\n"; // Хозорган

    return str;
}

/*
Не задействованные функции
armSkif.getEventDev(numPKU, n);  // Номер прибора
armSkif.getEventUnit(numPKU, n); // Агрегат (шлейф/реле/считыватель)
armSkif.isUnitSh(numPKU, n); // Если событие относится к шлейфу
armSkif.isUnitRl(numPKU, n); // Если событие относится к реле
armSkif.isUnitRd(numPKU, n); // Если событие относится к считывателю
armSkif.getEventKey(numPKU, n); // Ключ (пароли не высвечиваются, только коды ключей)
*/
